figureDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 7 - Mass density against size and number/Figure components/'
csvDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 7 - Mass density against size and number/CSV/'

# BESE Transects -------------------

setwd(csvDirectory)
d = read.csv("bivalve_transect_data_complete.csv")
d = d[d$species == 'Mytilus edulis' | d$species == 'Crassostrea gigas',]
d$mass.g[d$species == 'Mytilus edulis' & !is.na(d$length.mm)] = 8.6887e-05 * d$length.mm[d$species == 'Mytilus edulis' & !is.na(d$length.mm)] ^2.8832
d$mass.g[d$species == 'Crassostrea gigas' & !is.na(d$length.mm)] = 0.0001116122 * d$length.mm[d$species == 'Crassostrea gigas' & !is.na(d$length.mm)] ^2.84053

setwd('F:/Manuscripts/Chapter 4 - Oyster reef within saltmarsh/Manuscript/Figures & data/Figure 7 - Mass density against size and number/')
tiff(filename = '%04d.tif', width = 15,height = 12, units = 'cm', res = 300)
for(i in 1:2){
  col = alpha(c('blue','red'),0.5)
  species = c('Mytilus edulis','Crassostrea gigas')
  
  filter = d$species == species[i] & d$site == 'Paulina' 
  
  #sampleArea.m2 = tapply(d$sampleArea.m2[filter],d$inund_freq.perc[filter], unique)
  totalMass = tapply(d$mass.g[filter], d$inund_freq.perc[filter], sum)#/sampleArea.m2
  individualNumber = tapply(d$mass.g[filter], d$inund_freq.perc[filter], length)#/sampleArea.m2
  averageMass = tapply(d$mass.g[filter], d$inund_freq.perc[filter], mean)
  
  if(species[i] == 'Crassostrea gigas'){
    main = 'Average oyster mass (g)'
    col = c(alpha('red',0.6),alpha('red',0.3))
  } else if(species[i] == 'Mytilus edulis'){
    main = 'Average mussel mass (g)'
    col = c(alpha('blue',0.6),alpha('blue',0.3))
  }
  
  # ----------------
  
  par(mar = c(5,5,4,4))
  plot(totalMass ~ averageMass, 
       ylab = expression(paste('Mass density (g sample'^'-2',')')),
       xlab = 'Average individual size (g)',
       log = 'yx', pch = 22, bg = col[i],
       xlim = c(0.5,10), yaxt = 'n', #xaxt = 'n',
       ylim = c(10, 500), cex.axis = 1.2, cex.lab = 1.2)
  axis(side = 2, labels = c(0.5,1,5,10,50,100,500), at = c(0.5,1,5,10,50,100,500), cex.axis = 1.2)
  axis(side = 3, labels = species[i], at = 2.23, font = 2, tick = F, cex.axis = 1.2)
  # axis(side = 1, labels = 10^c(-10:10), at = 10^c(-10:10))
  m = lm(log(totalMass) ~ log(averageMass))# * site)
  xv = seq(min(averageMass), max(averageMass), length.out = 1000)     
  yv = exp(m$coefficients[1] + m$coefficients[2]*log(xv))
  lines(yv ~ xv, col = col[i], lwd = 2)
  lines(yv ~ xv, lty = 2, cex = 0.8)
  # if(species[i] == 'Crassostrea gigas'){
  #   # (F(1,9) = 36.38, n = 11, p < 0.001, R2 = 0.78)
  #   text(y = 12, x = 2.23, expression(paste('(','F'['1,9'],' = 36.38, n = 11, ', 'R'^'2', '= 0.78, p < 0.001)')))
  # } else if(species[i] == 'Mytilus edulis'){
  #   # (F(1,9) = 2.2, n = 11, p = 0.1722, R2 = 0.107)
  #   text(y = 12, x = 2.23, expression(paste('(','F'['1,9'],' = 2.2, n = 11, ', 'R'^'2', '= 0.107, p = 0.1722)')))
  # }
  # text(y = 450, x= 2.23, species[i], font = 2, cex = 1.1)
  
  plot(totalMass ~ individualNumber, 
       ylab = expression(paste('Mass density (g sample'^'-2',')')),
       xlab = 'Individual Number',
       log = 'yx', pch = 22, bg = col[i],
       xlim = c(10,250), yaxt = 'n', #xaxt = 'n',
       ylim = c(10, 500), cex.axis = 1.2, cex.lab = 1.2)
  axis(side = 2, labels = c(0.5,1,5,10,50,100,500), at = c(0.5,1,5,10,50,100,500), cex.axis = 1.2)
  axis(side = 3, labels = species[i], at = 50, font = 2, tick = F, cex.axis = 1.2)
  #axis(side = 1, labels = 10^c(-10:10), at = 10^c(-10:10))
  m = lm(log(totalMass) ~ log(individualNumber))# * site)
  xv = seq(min(individualNumber), max(individualNumber), length.out = 1000)     
  yv = exp(m$coefficients[1] + m$coefficients[2]*log(xv))
  lines(yv ~ xv, col = col[i], lwd = 2)
  lines(yv ~ xv, lty = 2, cex = 0.8)
  # if(species[i] == 'Crassostrea gigas'){
  #   # (F(1,9) = 4.7, n = 11, p = 0.06, R2 = 0.27)
  #   text(y = 12, x = 50, expression(paste('(','F'['1,9'],' = 4.7, n = 11, ', 'R'^'2', '= 0.27, p = 0.06)')))
  # } else if(species[i] == 'Mytilus edulis'){
  #   # (F(1,9) = 175.7, n = 11, p < 0.001, R2 = 0.946)
  #   text(y = 12, x = 50, expression(paste('(','F'['1,9'],' = 175.7, n = 11, ', 'R'^'2', '= 0.946, p < 0.001)')))
  # }
  # text(y = 450, x= 50, species[i], font = 2, cex = 1.1)
  
  filter = d$site == 'Paulina'
  m1 = lm(log(totalMass) ~ log(averageMass))# * site)
  m2 = lm(log(totalMass) ~ log(individualNumber))# * site)
  summary(m1)
  summary(m2)
  
  # Mussel mass density driven by average individual size
  # (F(1,9) = 2.2, n = 11, p = 0.1722, R2 = 0.107)
  # Mussel mass density driven by individual number
  # (F(1,9) = 175.7, n = 11, p < 0.001, R2 = 0.946)
  
  # Oyster mass density driven by average individual size
  # (F(1,9) = 36.38, n = 11, p < 0.001, R2 = 0.78)
  # Oyster mass density driven by individual number
  # (F(1,9) = 4.7, n = 11, p = 0.06, R2 = 0.27)
  
  # ---------------------
  # Second analysis for Reviewer 1:
  
  # Computing R2
  y = totalMass
  x = averageMass
  z = individualNumber
  xz = x*z 
  corX = cor(x = x, y = y)^2
  corZ = cor(x = z, y = y)^2
  corXZ = cor(x = xz, y = y)^2
  print(corX)
  print(corZ)
  corXZ
  
}
setwd(figureDirectory)
dev.off()
